/*====================================================================================
 
	Sonique Visual Plugin API
        (c) 1999 Sonique Team

		edited as applies to Shareaza.
		Modify Name (Line 38) and Render function (Line 135).

====================================================================================*/

#include <windows.h>
#include "vis.h"

/*====================================================================================
	Definitions of Plugin functions (leave as is)
====================================================================================*/
void initialize(void);
BOOL render(unsigned long* Video, int width, int height, int pitch, VisData* pVD);
BOOL savesettings(char* FileName);
BOOL opensettings(char* FileName);

/*====================================================================================
	The actual details for your plugin

	1. Reserved (leave as NULL)
	2. Plug-In Name (char*, displayed in Vis selection menu)
	3. Options (Remove unneeded options)
		VI_WAVEFORM - if you need waveform PCM data
		VI_SPECTRUM - if you need spectrum FFT data
		SONIQUEVISPROC - calls user defined effects (unavailable)
	4. Initialize function (leave as is)
	5. Render function (leave as is)
	6. SaveSettings function (leave as is)
	7. OpenSettings function (leave as is)
====================================================================================*/
VisInfo plugin = 
{
	NULL,
	"Yellow Fill Demo",
	VI_WAVEFORM|VI_SPECTRUM,
	&initialize,
	&render,
	&savesettings,
	&opensettings
};

/*====================================================================================
	Definition of the DLL export (leave as is)
====================================================================================*/
DLLEXPORT VisInfo* QueryModule(void)
{
	return &plugin;
}

/*====================================================================================
	Definition of the Initialize function

		Called before plugin start. Fill with initializations or leave blank.

		(Can leave empty as is)
====================================================================================*/
void initialize(void)
{
}

/*====================================================================================
	Definition of the OpenSettings function

		to open settings regarding your plugin,
		use GetPrivateProfileString to save the settings.

			char BrightnessBuffer[256];
			GetPrivateProfileString("my plugin", "brightness", "3", 
			BrightnessBuffer, sizeof(BrightnessBuffer), FileName);

		return TRUE, or FALSE if failed.

		(leave empty as is)
====================================================================================*/
BOOL opensettings(char* FileName)
{
	return TRUE;
}

/*====================================================================================
	Definition of the SaveSettings function

		to save settings regarding your plugin,
		use WritePrivateProfileString to save the settings.

			WritePrivateProfileString("my plugin", "brightness", "3", FileName);

		return TRUE, or FALSE if failed.

		(leave empty as is)
====================================================================================*/
BOOL savesettings(char* FileName)
{
	return TRUE;
}

/*====================================================================================
	Definition of the Render function

		This is where to locate the visual code, 
		it is the only function that must be filled in.

			Render should draw a whole frame into the 32 bit ABGR buffer.
			(for blur, smoke, and zoom effects: add using bitwise, alpha blend,
			or saturated add, rather than replacing video data).

			'Pitch' specifies the distance between the start of each line. 
			If you have a pointer at the start of a line, 
			Pointer+Pitch is the start of the next line and 
			Pointer-Pitch is the start of the previous line.
			(Pitch is in pixels and can be negative.)

			Called for each frame.
			Be certain not to exceed the given boundaries.
			 
			Render like this:

			for (y = 0; y < height; y++)
			{
			  for (x = 0; x < width; x++)
			      Video[x] = <pixel value>;
			  Video += pitch;
			}

				OR

			void PutPixel(int x, int y, unsigned long Pixel)
			{
			  _ASSERT( x >= 0 && x < width && y >= 0 && y < height );
			  Video[y*pitch+x] = Pixel;
			}

		return TRUE when finished draw to the buffer.

====================================================================================*/
BOOL render(unsigned long* Video, int width, int height, int pitch, VisData* pVD)
{
	int x, y;

	// travel the width of the buffer

	for(x = 0; x < width; x ++)
	{
		// Simple yellow block fill example:
		// Draw the left channel spectrum data, on the left side, 
		// if data is greater than half the height of the buffer 
		// it is cut down to prevent buffer overuns.  
		// Do the same with right channel data, on the right side. 


		if ( x < width/2 ) {
		y = ((height/2) - pVD->Spectrum[0][x&255]);
		if(y < 0) y = height/2;
		Video[y*pitch + x] = 0x20ffffff - x*512/width;
		Video[y*pitch-1 + x] = 0x20101010;
		}

		else {
		y = ((height/2) + pVD->Spectrum[1][x&255]);
		if(y > (height-1)) y = height/2;
		Video[y*pitch + x] = (0x20ffff00) + x*512/width;
		Video[y*pitch-1 + x] = 0x20101010;
		}
	}

	return TRUE;
}